<?php

namespace GoDaddy\WordPress\MWC\Core\Features\Commerce\Catalog\Providers\DataObjects\Categories;

use GoDaddy\WordPress\MWC\Core\Features\Commerce\Catalog\Providers\DataObjects\ImageAsset;
use GoDaddy\WordPress\MWC\Core\Features\Commerce\Catalog\Providers\DataObjects\VideoAsset;
use GoDaddy\WordPress\MWC\Core\Features\Commerce\Providers\DataObjects\AbstractDataObject;
use GoDaddy\WordPress\MWC\Core\Features\Commerce\Providers\DataObjects\ExternalId;

/**
 * Category data object.
 */
class Category extends AbstractDataObject
{
    /** @var string|null a separate unique identifier for this category */
    public ?string $altId = null;

    /** @var array<ImageAsset|VideoAsset>|null a collection of assets in the order they should be presented (the first assets is the default one) */
    public ?array $assets = null;

    /** @var string|null the unique identifier for the category */
    public ?string $categoryId = null;

    /** @var string|null datetime when the category was created, as ISO 8601 (will be autogenerated if unspecified) */
    public ?string $createdAt = null;

    /** @var int nested depth in the family tree */
    public int $depth = 0;

    /** @var string|null category description */
    public ?string $description = null;

    /** @var ?ExternalId[] a collection of alternate identifiers for the category */
    public ?array $externalIds = null;

    /** @var object[]|null metadata associated with the category -- we do not support this field at this time, as we do not currently read or write metadata */
    public ?array $metadata = null;

    /** @var string name of the category */
    public string $name;

    /** @var string|null the unique identifier for the parent */
    public ?string $parentId = null;

    /** @var string[]|null product IDs associated with this category -- we do not support this field at this time, as holding all product IDs in memory for each category would hog resources unnecessarily */
    public ?array $productIds = null;

    /** @var int display sequence of the category */
    public int $sequence = 1;

    /** @var string|null datetime when the category was last updated, as ISO 8601 (will be autogenerated if unspecified) */
    public ?string $updatedAt = null;

    /** @var string|null datetime when the category was deleted, as ISO 8601 */
    public ?string $deletedAt = null;

    /**
     * Constructor.
     *
     * @param array{
     *     altId?: string|null,
     *     assets?: array<ImageAsset|VideoAsset>|null,
     *     categoryId?: string|null,
     *     createdAt?: string|null,
     *     depth?: int,
     *     description?: string|null,
     *     externalIds?: ExternalId[]|null,
     *     name: string,
     *     parentId?: string|null,
     *     sequence?: int,
     *     updatedAt?: string|null,
     *     deletedAt?: string|null,
     * } $data
     */
    public function __construct(array $data)
    {
        parent::__construct($data);
    }
}
